#ifndef __GPS_H__

#define __GPS_H__

/* 

	GPS Module Drivers, by Mauro Grassi, October 2010.

*/

#include "clock.h"

#define GPS_NO_ERROR				0x00
#define GPS_OVERRUN_ERROR			0x01
#define GPS_OVERFLOW_ERROR			0x02
#define GPS_UNDERFLOW_ERROR			0x04

#define MAX_GPS_PIPE_LENGTH			96
#define MAX_GPS_TEMPSTRING			64
#define MAX_GPS_OUTPUT				40

#define GPS_START_CHAR				'$'	   
#define GPS_END_PAYLOAD_CHAR		'*'
#define GPS_END_CHAR				0x0A	/* LF */
#define GPS_DELIMITER				','

#define GPS_IDLE_STATE				0
#define GPS_PAYLOAD_STATE			1
#define GPS_FIRST_CRC_CHAR_STATE	2
#define GPS_SECOND_CRC_CHAR_STATE	3
#define GPS_ALL_RECEIVED_STATE		4
#define GPS_ALL_DONE_STATE			5

#define GGA_MSG						0
#define GLL_MSG						1
#define GSA_MSG						2
#define GSV_MSG						3
#define RMC_MSG						4
#define VTG_MSG						5

typedef struct 
{
	volatile unsigned char  GPSLastRx;
	volatile unsigned char	GPSTxCRC;
	volatile unsigned char  GPSPipe[MAX_GPS_PIPE_LENGTH];
	volatile unsigned char 	GPSTempString[MAX_GPS_TEMPSTRING];
	volatile unsigned char  GPSTempPtr;
	volatile unsigned char  GPSPipePutPtr;
	volatile unsigned char  GPSPipeGetPtr;
	volatile unsigned char	GPSRxCRC;
	volatile unsigned char  GPSPipeState;
	volatile unsigned char  GPSError;
	volatile unsigned char 	GPSOutput[MAX_GPS_OUTPUT];
	volatile unsigned char  GPSOutPtr;
	float				 	GPSLongitude;
	float					GPSLatitude;
	float					GPSSpeed;
	float					GPSCourse;
	volatile unsigned char  GPSNewRx;
} GPS_DATA_OBJECT;

unsigned char 	GPSPipeGet(void);
unsigned char 	GPSPipePut(unsigned char g);
void 			sendCGPS(unsigned char c);
void 			showGPSPipe(void);
unsigned char 	disFixGPS(unsigned char c);
unsigned char 	disGetGPS(unsigned char c);
void 			sendCharGPS(unsigned char c);
void 			startGPSCommand(unsigned rom const char* cmd);
void 			continueGPSCommand(unsigned char* instring);
void 			endGPSCommand(void);
void 			sendDecimalNumberGPSCommand(long num, unsigned int charToPrint);
void 			PSRF103Command(unsigned char msgtype, unsigned char query, unsigned char rate, unsigned char chksum);
void 			initGPSModule(void);
void 			initGPSBaudRate(float baudRequired);
void 			initGPS(float baudRequired);
void 			GPSTask(unsigned char verbose);
void 			outputNMEAX(unsigned char* in, unsigned char* out, unsigned char* outIndex, unsigned char todoOut, unsigned char outSize);
unsigned char	matchNMEAString(unsigned char* cmd, const rom unsigned char* cmdRom, unsigned char* src, unsigned char* out, unsigned char* cmdIndex, unsigned char* srcIndex, unsigned char* outIndex, unsigned char srcSize, unsigned char outSize);
unsigned char*  getNMEAX(unsigned char* in, unsigned char* out, unsigned char todoOut);

#endif
